/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class AbstractLootProviderV2 {
    private AbstractLootProviderV2() {
    }

    public static interface LootTableDataProvider
    extends DataProvider {
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> var1);

        public PackOutput.PathProvider pathProvider();

        public LootContextParamSet paramSet();

        public boolean skipValidationFor(ResourceLocation var1);

        default public CompletableFuture<?> m_213708_(CachedOutput output) {
            HashMap<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
            Object2ObjectOpenHashMap seeds = new Object2ObjectOpenHashMap();
            this.m_245126_((arg_0, arg_1) -> this.lambda$run$0((Map)seeds, lootTables, arg_0, arg_1));
            this.validate(lootTables);
            return CompletableFuture.allOf((CompletableFuture[])lootTables.entrySet().stream().map(entry -> {
                ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
                LootTable lootTable = (LootTable)entry.getValue();
                Path path = this.pathProvider().m_245731_(resourceLocation);
                return DataProvider.m_253162_((CachedOutput)output, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree((Object)lootTable), (Path)path);
            }).toArray(CompletableFuture[]::new));
        }

        default public void validate(final Map<ResourceLocation, LootTable> tables) {
            ValidationContext validationContext = new ValidationContext(LootContextParamSets.f_81420_, new LootDataResolver(){

                @Nullable
                public <T> T m_278667_(LootDataId<T> lootDataId) {
                    if (lootDataId.f_278383_() == LootDataType.f_278413_) {
                        LootTable lootTable = this.skipValidationFor(lootDataId.f_278500_()) ? LootTable.m_79147_().m_79167_() : (LootTable)tables.get(lootDataId.f_278500_());
                        return (T)lootTable;
                    }
                    return null;
                }
            });
            tables.forEach((resourceLocation, lootTable) -> this.validate((ResourceLocation)resourceLocation, (LootTable)lootTable, validationContext));
            Multimap multimap = validationContext.m_79352_();
            if (!multimap.isEmpty()) {
                multimap.forEach((string, string2) -> f_252483_.warn("Found validation problem in {}: {}", string, string2));
                throw new IllegalStateException("Failed to validate loot tables, see logs");
            }
        }

        default public void validate(ResourceLocation resourceLocation, LootTable lootTable, ValidationContext validationContext) {
            if (!this.skipValidationFor(resourceLocation)) {
                lootTable.m_79136_(validationContext.m_79355_(lootTable.m_79122_()).m_278632_("{" + resourceLocation + "}", new LootDataId(LootDataType.f_278413_, resourceLocation)));
            }
        }

        private /* synthetic */ void lambda$run$0(Map seeds, Map lootTables, ResourceLocation resourceLocation, LootTable.Builder builder) {
            ResourceLocation resourceLocation2 = seeds.put(RandomSequence.m_288221_((ResourceLocation)resourceLocation), resourceLocation);
            if (resourceLocation2 != null) {
                f_252483_.error("Loot table random sequence seed collision on " + resourceLocation2 + " and " + resourceLocation);
            }
            builder.m_287223_(resourceLocation);
            if (lootTables.put(resourceLocation, builder.m_79165_(this.paramSet()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }
    }

    public static abstract class Simple
    implements LootTableSubProvider,
    LootTableDataProvider {
        private final Map<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        private final Set<ResourceLocation> skipValidation = Sets.newHashSet();
        private final LootContextParamSet paramSet;
        private final PackOutput.PathProvider pathProvider;

        public Simple(LootContextParamSet paramSet, DataProviderContext context) {
            this(paramSet, context.getPackOutput());
        }

        public Simple(LootContextParamSet paramSet, PackOutput packOutput) {
            this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
            this.paramSet = paramSet;
        }

        public String m_6055_() {
            return String.join((CharSequence)" ", StringUtils.splitByCharacterTypeCamelCase((String)this.getClass().getSimpleName()));
        }

        @Override
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> exporter) {
            this.addLootTables();
            this.tables.forEach(exporter);
        }

        @Override
        public PackOutput.PathProvider pathProvider() {
            return this.pathProvider;
        }

        @Override
        public LootContextParamSet paramSet() {
            return this.paramSet;
        }

        @Override
        public boolean skipValidationFor(ResourceLocation resourceLocation) {
            return this.skipValidation.contains(resourceLocation);
        }

        public void skipValidation(ResourceLocation resourceLocation) {
            this.skipValidation.add(resourceLocation);
        }

        protected void add(ResourceLocation table, LootTable.Builder builder) {
            this.tables.put(table, builder);
        }

        public abstract void addLootTables();
    }

    public static abstract class EntityTypes
    extends EntityLootSubProvider
    implements LootTableDataProvider {
        private final Set<ResourceLocation> skipValidation = Sets.newHashSet();
        private final PackOutput.PathProvider pathProvider;
        private final String modId;
        private final Map<EntityType<?>, Map<ResourceLocation, LootTable.Builder>> map = new HashMap();

        public EntityTypes(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput());
        }

        public EntityTypes(String modId, PackOutput packOutput) {
            super(FeatureFlags.f_244280_.m_247355_());
            this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
            this.modId = modId;
        }

        public String m_6055_() {
            return "Entity Type Loot Tables";
        }

        public final void m_246942_() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        @Override
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.m_246942_();
            HashSet set = new HashSet();
            this.getRegistryEntries().forEach(holder -> {
                EntityType entityType = (EntityType)holder.m_203334_();
                Map<ResourceLocation, LootTable.Builder> map = this.map.remove(entityType);
                if (this.m_245552_(entityType)) {
                    ResourceLocation lootTableLocation = entityType.m_20677_();
                    if (!(lootTableLocation.equals((Object)BuiltInLootTables.f_78712_) || map != null && map.containsKey(lootTableLocation))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loot table '%s' for '%s'", lootTableLocation, holder.m_205785_().m_135782_()));
                    }
                    if (map != null) {
                        map.forEach((resourceLocation, builder) -> {
                            if (!set.add(resourceLocation)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loot table '%s' for '%s'", resourceLocation, holder.m_205785_().m_135782_()));
                            }
                            consumer.accept((ResourceLocation)resourceLocation, (LootTable.Builder)builder);
                        });
                    }
                } else if (map != null) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Weird loot table(s) '%s' for '%s', not a LivingEntity so should not have loot", map.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(",")), holder.m_205785_().m_135782_()));
                }
            });
            if (!this.map.isEmpty()) {
                throw new IllegalStateException("Created loot tables for entities not supported by data pack: " + this.map.keySet());
            }
        }

        protected final void m_247520_(EntityType<?> entityType, ResourceLocation lootTableLocation, LootTable.Builder builder) {
            this.map.computeIfAbsent(entityType, entityTypeX -> new HashMap()).put(lootTableLocation, builder);
        }

        @Override
        public PackOutput.PathProvider pathProvider() {
            return this.pathProvider;
        }

        @Override
        public LootContextParamSet paramSet() {
            return LootContextParamSets.f_81415_;
        }

        @Override
        public boolean skipValidationFor(ResourceLocation resourceLocation) {
            return this.skipValidation.contains(resourceLocation);
        }

        public void skipValidation(ResourceLocation resourceLocation) {
            this.skipValidation.add(resourceLocation);
        }

        public void skipValidation(EntityType<?> entityType) {
            this.skipValidation(entityType.m_20677_());
        }

        protected boolean m_245552_(EntityType<?> entityType) {
            return entityType.m_20674_() != MobCategory.MISC;
        }

        protected Stream<Holder.Reference<EntityType<?>>> getRegistryEntries() {
            return BuiltInRegistries.f_256780_.m_203611_().filter(holder -> holder.m_205785_().m_135782_().m_135827_().equals(this.modId));
        }
    }

    public static abstract class Blocks
    extends BlockLootSubProvider
    implements LootTableDataProvider {
        private final Set<ResourceLocation> skipValidation = Sets.newHashSet();
        private final PackOutput.PathProvider pathProvider;
        private final String modId;

        public Blocks(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput());
        }

        public Blocks(String modId, PackOutput packOutput) {
            super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
            this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
            this.modId = modId;
        }

        public String m_6055_() {
            return "Block Loot Tables";
        }

        public final void m_245660_() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        @Override
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.m_245660_();
            HashSet set = new HashSet();
            this.getRegistryEntries().forEach(holder -> {
                ResourceLocation lootTableLocation = ((Block)holder.m_203334_()).m_60589_();
                if (lootTableLocation != BuiltInLootTables.f_78712_ && set.add(lootTableLocation)) {
                    LootTable.Builder builder = (LootTable.Builder)this.f_244441_.remove(lootTableLocation);
                    if (builder == null) {
                        throw new IllegalStateException("Missing loot table '%s' for '%s'".formatted(lootTableLocation, holder.m_205785_().m_135782_()));
                    }
                    consumer.accept(lootTableLocation, builder);
                }
            });
            if (!this.f_244441_.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.f_244441_.keySet());
            }
        }

        @Override
        public PackOutput.PathProvider pathProvider() {
            return this.pathProvider;
        }

        @Override
        public LootContextParamSet paramSet() {
            return LootContextParamSets.f_81421_;
        }

        @Override
        public boolean skipValidationFor(ResourceLocation resourceLocation) {
            return this.skipValidation.contains(resourceLocation);
        }

        public void skipValidation(ResourceLocation resourceLocation) {
            this.skipValidation.add(resourceLocation);
        }

        public void skipValidation(Block block) {
            this.skipValidation(block.m_60589_());
        }

        public void dropNothing(Block block) {
            this.m_247577_(block, Blocks.m_246386_());
        }

        public void dropNameable(Block block) {
            this.m_246481_(block, x$0 -> this.m_246180_((Block)x$0));
        }

        protected Stream<Holder.Reference<Block>> getRegistryEntries() {
            return BuiltInRegistries.f_256975_.m_203611_().filter(holder -> holder.m_205785_().m_135782_().m_135827_().equals(this.modId));
        }
    }
}

